package net.kldp.logviewer.work;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import net.kldp.logviewer.View;
import net.kldp.logviewer.common.log.LogViews;
import net.kldp.logviewer.model.LogViewerEntry;

import org.apache.log4j.Logger;

/**
 *  ֱ оִ Thread̴.
 * 
 * )   ִ κ ϰ   ִ.
 * 
 * @author hangumkj
 */
public class WorkerFileTail extends Thread implements Tail {
	
	private static final Logger logger = LogViews.getLogger(WorkerFileTail.class);
	
	View view = null;
	LogViewerEntry viewEntry = null;
	private volatile boolean shutdownThread = false;
	private volatile boolean sleepThread = false;
    
	public WorkerFileTail(LogViewerEntry viewEntry, View tailMe) {
		if(logger.isDebugEnabled()) { 
			logger.debug("WorkerFileTail Started......[name]" + viewEntry.getName());
		}
		this.view = tailMe;
		
		outputLog(viewEntry.getRealPath() + " ⸦ մϴ.\r\n");		
		this.viewEntry = viewEntry;
	}
	
	/**
	 * ߴ
	 */
	public void sleep() {
		sleepThread = true;
		
		try {
			Thread.currentThread().wait();
		} catch(InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * ٽý
	 */
	public void reStart() {
		sleepThread = false;		
		
		Thread.currentThread().notify();
	}
	
	/**
	 *  
	 *
	 */
	public void shutdown() {
		shutdownThread = true;
		interrupt();
	}
	
	public void run() {
		BufferedInputStream bis = null;
		
		try {
			int length = -1;
			
			boolean findFile = false;
			try {
				bis = new BufferedInputStream(new FileInputStream(viewEntry.getRealPath()), 1024);			
				
			    //  Ʈ ̵Ѵ.
			    bis.skip(new File(viewEntry.getRealPath()).length());
			    
			    findFile = true;
			} catch(IOException ioe) {
				findFile = false;
				outputLog(ioe.getMessage());
			}
			
		    while(!shutdownThread) {
		    	
		    	try {
		    		// thread wait ̴.
					if(sleepThread) {
						
					// working 
					} else {
						//  ߰ߵ    ã´.
				    	if(!findFile) {
					    	try {
								bis = new BufferedInputStream(new FileInputStream(viewEntry.getRealPath()), 1024);			
								
							    length = bis.available();     
					    		if (length == -1) throw new IOException("   ʽϴ. Ȯ ֽʽÿ.");        
					    
					    		if (length > 0) {		        
					    			byte[] data = new byte[length];
					    			
					    			if (bis.read(data, 0, length) != -1) outputLog(data);
					    		}
							    
							    findFile = true;
							} catch(IOException ioe) {
								findFile = false;
								outputLog(ioe.getMessage());
							}
						//  ã...
				    	} else {
				    		length = bis.available();     
				    		if (length == -1) throw new IOException("   ʽϴ. Ȯ ֽʽÿ.");        
				    
				    		if (length > 0) {		        
				    			byte[] data = new byte[length];
				    			
				    			if (bis.read(data, 0, length) != -1) outputLog(data);
				    		}
				    			
				    	} //  ߰ߵƴ ˻ if			    		
			       
			    		// ϴ ðŭ  ȴ. 
			    		try {
			    			Thread.sleep(viewEntry.getDelaySecond() * 1000);
			    		} catch(InterruptedException e) {}
					}
		    	} catch (Exception e) {
		    		e.printStackTrace();
		    		outputLog(e.getMessage());
		    	}
		    }
		} catch (Exception e) {
			e.printStackTrace();
			
			outputLog(e.getMessage());					
		} finally {
			try { bis.close(); } catch(IOException ioe){}
			logger.debug("###[WorkerFileTail  ۾] ");// + Thread.currentThread().getId());
		}
	}

	/**
	 * ȭ鿡 ϱ  work ִ Ȱ Ѵ.
	 * 
	 * @param data
	 */
	protected void outputLog(byte[] data) {
		if(!new String(data).equals("")) view.fileAddData(new String(data));
	}
	
	protected void outputLog(String data) {
		if(!"".equals(data)) view.fileAddData(data);
	}
}
